/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.message;

import com.refinedmods.refinedpipes.blockentity.FluidPipeBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class FluidPipeMessage {
    private BlockPos pos;
    private FluidStack fluid;
    private float fullness;

    public FluidPipeMessage(BlockPos pos, FluidStack fluid, float fullness) {
        this.pos = pos;
        this.fluid = fluid;
        this.fullness = fullness;
    }

    public FluidPipeMessage() {
    }

    public static void encode(FluidPipeMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeFluidStack(message.fluid);
        buf.writeFloat(message.fullness);
    }

    public static FluidPipeMessage decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        FluidStack fluid = buf.readFluidStack();
        float fullness = buf.readFloat();
        return new FluidPipeMessage(pos, fluid, fullness);
    }

    public static void handle(FluidPipeMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
            if (blockEntity instanceof FluidPipeBlockEntity) {
                ((FluidPipeBlockEntity)blockEntity).setFluid(message.fluid);
                ((FluidPipeBlockEntity)blockEntity).setFullness(message.fullness);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

